<?php $__env->startSection('title', 'Our Services - ENT Care Center'); ?>
<?php $__env->startSection('meta_description', 'Comprehensive ENT services including diagnosis and treatment for ear, nose, and throat conditions.'); ?>

<?php $__env->startSection('content'); ?>
<!-- Page Header -->
<!-- Page Header -->
<section class="relative h-[40vh] min-h-[400px] flex items-center justify-center overflow-hidden bg-primary-900">
    <div class="absolute inset-0 bg-gradient-to-br from-primary-900 via-primary-800 to-primary-900 opacity-90"></div>
    <div class="absolute inset-0 bg-[url('/img/pattern.png')] opacity-10"></div>
    
    <!-- Animated shapes -->
    <div class="absolute top-20 left-10 w-64 h-64 bg-primary-500/20 rounded-full blur-3xl animate-pulse-slow"></div>
    <div class="absolute bottom-10 right-10 w-80 h-80 bg-accent-500/20 rounded-full blur-3xl animate-pulse-slow" style="animation-delay: 1s;"></div>
    
    <div class="relative z-10 text-center text-white px-4">
        <h1 class="text-4xl sm:text-5xl md:text-6xl font-bold mb-6 tracking-tight">Our Services</h1>
        <p class="text-lg sm:text-xl text-primary-100 max-w-2xl mx-auto font-light leading-relaxed">Comprehensive ENT care for all your needs, delivered with expertise and compassion.</p>
    </div>
</section>

<!-- Services List -->
<section class="py-20 bg-secondary-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold text-secondary-900 mb-4 tracking-tight">Comprehensive ENT Services</h2>
            <p class="text-lg text-secondary-600 max-w-3xl mx-auto font-light">We offer a wide range of specialized services to diagnose and treat various ear, nose, and throat conditions.</p>
        </div>
        
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-8">
            <?php $__empty_1 = true; $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div x-data="{ hover: false }"
                 @mouseenter="hover = true"
                 @mouseleave="hover = false"
                 class="bg-white rounded-2xl p-8 shadow-sm hover:shadow-soft transition-all duration-300 group cursor-pointer border border-secondary-100"
                 onclick="window.location.href='<?php echo e(route('services.show', $service->slug)); ?>'">
                <div class="w-16 h-16 bg-primary-50 rounded-2xl flex items-center justify-center mb-6 text-primary-600 group-hover:bg-primary-600 group-hover:text-white transition-all duration-300">
                    <?php if($service->icon): ?>
                        <i class="<?php echo e($service->icon); ?> text-3xl"></i>
                    <?php else: ?>
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"></path>
                        </svg>
                    <?php endif; ?>
                </div>
                <h3 class="text-xl font-bold text-secondary-900 mb-3 group-hover:text-primary-600 transition-colors"><?php echo e($service->name); ?></h3>
                <p class="text-secondary-600 mb-4 line-clamp-3 leading-relaxed"><?php echo e($service->description); ?></p>
                <a href="<?php echo e(route('services.show', $service->slug)); ?>" 
                   class="inline-flex items-center text-primary-600 font-semibold group-hover:gap-2 transition-all">
                    Learn More
                    <svg class="w-4 h-4 ml-1 transform group-hover:translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                    </svg>
                </a>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="col-span-full text-center py-12">
                <p class="text-secondary-500 text-lg">No services available at the moment. Please check back later.</p>
            </div>
            <?php endif; ?>
        </div>
    </div>
</section>

<!-- Why Choose Our Services -->
<section class="py-20 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="text-3xl md:text-4xl font-bold text-secondary-900 mb-4 tracking-tight">Why Choose Our Services?</h2>
            <p class="text-lg text-secondary-600 max-w-2xl mx-auto font-light">We are committed to providing exceptional ENT care with a focus on patient comfort and positive outcomes.</p>
        </div>
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div class="text-center p-8 rounded-2xl bg-secondary-50 hover:bg-white hover:shadow-soft transition-all duration-300 border border-transparent hover:border-secondary-100">
                <div class="w-16 h-16 bg-blue-100 text-blue-600 rounded-2xl flex items-center justify-center mx-auto mb-6">
                    <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.663 17h4.673M12 3v1m6.364 1.636l-.707.707M21 12h-1M4 12H3m3.343-5.657l-.707-.707m2.828 9.9a5 5 0 117.072 0l-.548.547A3.374 3.374 0 0014 18.469V19a2 2 0 11-4 0v-.531c0-.895-.356-1.754-.988-2.386l-.548-.547z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-secondary-900 mb-3">Advanced Technology</h3>
                <p class="text-secondary-600 leading-relaxed">We use state-of-the-art diagnostic and treatment equipment to ensure accurate diagnosis.</p>
            </div>
            <div class="text-center p-8 rounded-2xl bg-secondary-50 hover:bg-white hover:shadow-soft transition-all duration-300 border border-transparent hover:border-secondary-100">
                <div class="w-16 h-16 bg-purple-100 text-purple-600 rounded-2xl flex items-center justify-center mx-auto mb-6">
                    <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-secondary-900 mb-3">Expert Team</h3>
                <p class="text-secondary-600 leading-relaxed">Our board-certified specialists have years of experience and are dedicated to providing the best care.</p>
            </div>
            <div class="text-center p-8 rounded-2xl bg-secondary-50 hover:bg-white hover:shadow-soft transition-all duration-300 border border-transparent hover:border-secondary-100">
                <div class="w-16 h-16 bg-green-100 text-green-600 rounded-2xl flex items-center justify-center mx-auto mb-6">
                    <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-bold text-secondary-900 mb-3">Personalized Care</h3>
                <p class="text-secondary-600 leading-relaxed">We develop customized treatment plans tailored to each patient's unique needs and circumstances.</p>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="py-20 bg-primary-600 relative overflow-hidden">
    <!-- Decorative patterns -->
    <div class="absolute top-0 left-0 -ml-20 -mt-20 w-80 h-80 rounded-full bg-primary-500 opacity-20 blur-3xl"></div>
    <div class="absolute bottom-0 right-0 -mr-20 -mb-20 w-80 h-80 rounded-full bg-accent-500 opacity-20 blur-3xl"></div>
    
    <div class="relative z-10 max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center text-white">
        <h2 class="text-3xl md:text-5xl font-bold mb-6 tracking-tight">Need to Schedule an Appointment?</h2>
        <p class="text-lg md:text-xl mb-10 text-primary-100 font-light">Contact us today to discuss your ENT care needs with our expert team.</p>
        <a href="<?php echo e(route('appointment.create')); ?>" 
           class="inline-flex items-center space-x-2 px-8 py-4 bg-white text-primary-600 rounded-xl font-bold text-lg shadow-xl hover:shadow-2xl hover:-translate-y-1 transition-all duration-300">
            <span>Book Appointment</span>
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path>
            </svg>
        </a>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.modern', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/sumankc/Desktop/ Websites/ENT Care/resources/views/services/index.blade.php ENDPATH**/ ?>